IF EXISTS
    (
        SELECT *
            FROM SYS.VIEWS
            WHERE
                NAME = 'V_PDV_VD_FORMA_PGTO'
    )
    BEGIN
        DROP VIEW V_PDV_VD_FORMA_PGTO;
    END;
GO
CREATE VIEW [DBO].[V_PDV_VD_FORMA_PGTO]
AS
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                  AS CD_CONV
  , ''                 AS DS_CONV
  , 0                  AS VLR_CONV
  , 0                  AS VLR_DINH
  , 0                  AS VLR_NCC
  , 0                  AS VLR_CHQ_A_VISTA
  , 0                  AS VLR_CHQ_A_PRAZO
  , 0                  AS VLR_CARTAO_APRAZO
  , SUM(VLR_CARTAO)    AS VLR_CARTAO_DEBITO
  , 0                  AS VLR_CREDIARIO
  , 0                  AS VLR_CONV_PBM
  , RC_ADM_CARTAO.NM_USUAL
  , 'A VISTA'          AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                  AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                AS MATRICULA
  , 0                  AS FLAG_REQUER_NOTA_FISCAL
  , 0                  AS FLAG_REQUER_REQUISICAO
  , 0                  AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT AS NM_FILIAL
  , RC_ADM_CARTAO.CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_TEF ON PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
         INNER JOIN RC_ADM_CARTAO ON PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          RC_ADM_CARTAO.TP_ADM IN (1, 3)
      AND PDV_VD.ST_VD = 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , RC_ADM_CARTAO.NM_USUAL
           , RC_ADM_CARTAO.CD_ADM_CARTAO
           , PDV_VD.DT_VD
           , RC_CLI.CD_CLI
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT
UNION ALL
-----------------------------------CARTES A PRAZO
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                  AS CD_CONV
  , ''                 AS DS_CONV
  , 0                  AS VLR_CONV
  , 0                  AS VLR_DINH
  , 0                  AS VLR_NCC
  , 0                  AS VLR_CHQ_A_VISTA
  , 0                  AS VLR_CHQ_A_PRAZO
  , SUM(VLR_CARTAO)    AS VLR_CARTAO_APRAZO
  , 0                  AS VLR_CARTAO_DEBITO
  , 0                  AS VLR_CREDIARIO
  , 0                  AS VLR_CONV_PBM
  , RC_ADM_CARTAO.NM_USUAL
  , 'A VISTA'          AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                  AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                AS MATRICULA
  , 0                  AS FLAG_REQUER_NOTA_FISCAL
  , 0                  AS FLAG_REQUER_REQUISICAO
  , 0                  AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT AS NM_FILIAL
  , RC_ADM_CARTAO.CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_TEF ON PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
         INNER JOIN RC_ADM_CARTAO ON PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          RC_ADM_CARTAO.TP_ADM NOT IN (6, 1, 3)
      AND PDV_VD.ST_VD = 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , RC_ADM_CARTAO.NM_USUAL
           , RC_ADM_CARTAO.CD_ADM_CARTAO
           , PDV_VD.DT_VD
           , RC_CLI.CD_CLI
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT
UNION ALL

------------------------------------CREDIRIO
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                         AS CD_CONV
  , ''                        AS DS_CONV
  , 0                         AS VLR_CONV
  , 0                         AS VLR_DINH
  , 0                         AS VLR_NCC
  , 0                         AS VLR_CHQ_A_VISTA
  , 0                         AS VLR_CHQ_A_PRAZO
  , 0                         AS VLR_CARTAO_APRAZO
  , 0                         AS VLR_CARTAO_DEBITO
  , SUM(PDV_VD_TEF.VL_CARTAO) AS VLR_CREDIARIO
  , 0                         AS VLR_CONV_PBM
  , RC_ADM_CARTAO.NM_USUAL
  , 'A PRAZO'                 AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                         AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                       AS MATRICULA
  , 0                         AS FLAG_REQUER_NOTA_FISCAL
  , 0                         AS FLAG_REQUER_REQUISICAO
  , 0                         AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT        AS NM_FILIAL
  , RC_ADM_CARTAO.CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_TEF ON PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
        AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD
         INNER JOIN RC_ADM_CARTAO ON PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          RC_ADM_CARTAO.TP_ADM = 6
      AND PDV_VD.ST_VD = 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , RC_ADM_CARTAO.NM_USUAL
           , RC_ADM_CARTAO.CD_ADM_CARTAO
           , RC_ADM_CARTAO.TX_ADM
           , RC_ADM_CARTAO.PARC
           , PDV_VD.DT_VD
           , PDV_VD.ST_VD
           , RC_CLI.CD_CLI
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT
UNION ALL
----------------------------------------CHEQUES A VISTA
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                         AS CD_CONV
  , ''                        AS DS_CONV
  , 0                         AS VLR_CONV
  , 0                         AS VLR_DINH
  , 0                         AS VLR_NCC
  , SUM(CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ_A_VISTA
  , 0                         AS VLR_CHQ_A_PRAZO
  , 0                         AS VLR_CARTAO_APRAZO
  , 0                         AS VLR_CARTAO_DEBITO
  , 0                         AS VLR_CREDIARIO
  , 0                         AS VLR_CONV_PBM
  , ''                        AS NM_USUAL
  , 'A VISTA'                 AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                         AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                       AS MATRICULA
  , 0                         AS FLAG_REQUER_NOTA_FISCAL
  , 0                         AS FLAG_REQUER_REQUISICAO
  , 0                         AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT        AS NM_FILIAL
  , 0                         AS CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_CHQS ON PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_CHQS.CD_VD
         INNER JOIN CHQ_LANC_CPL ON PDV_VD_CHQS.NR_CHQ = CHQ_LANC_CPL.NR_CHQ
        AND PDV_VD_CHQS.AG_CHQ = CHQ_LANC_CPL.AG_CHQ
        AND PDV_VD_CHQS.ANO_CHQ = CHQ_LANC_CPL.ANO_CHQ
        AND PDV_VD_CHQS.SR_CHQ = CHQ_LANC_CPL.SR_CHQ
        AND PDV_VD_CHQS.CD_BC_CHQ = CHQ_LANC_CPL.CD_BC_CHQ
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          ST_VD = 0
      AND CHQ_LANC_CPL.DT_EMI = CHQ_LANC_CPL.DT_VENCTO
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , PDV_VD.DT_VD
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT
           , RC_CLI.CD_CLI
UNION ALL
----------------------------------------CHEQUES A PRAZO
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                         AS CD_CONV
  , ''                        AS DS_CONV
  , 0                         AS VLR_CONV
  , 0                         AS VLR_DINH
  , 0                         AS VLR_NCC
  , 0                         AS VLR_CHQ_A_VISTA
  , SUM(CHQ_LANC_CPL.VLR_CHQ) AS VLR_CHQ_A_PRAZO
  , 0                         AS VLR_CARTAO_APRAZO
  , 0                         AS VLR_CARTAO_DEBITO
  , 0                         AS VLR_CREDIARIO
  , 0                         AS VLR_CONV_PBM
  , ''                        AS NM_USUAL
  , 'A PRAZO'                 AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                         AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                       AS MATRICULA
  , 0                         AS FLAG_REQUER_NOTA_FISCAL
  , 0                         AS FLAG_REQUER_REQUISICAO
  , 0                         AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT        AS NM_FILIAL
  , 0                         AS CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_CHQS ON PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_CHQS.CD_VD
         INNER JOIN CHQ_LANC_CPL ON PDV_VD_CHQS.NR_CHQ = CHQ_LANC_CPL.NR_CHQ
        AND PDV_VD_CHQS.AG_CHQ = CHQ_LANC_CPL.AG_CHQ
        AND PDV_VD_CHQS.ANO_CHQ = CHQ_LANC_CPL.ANO_CHQ
        AND PDV_VD_CHQS.SR_CHQ = CHQ_LANC_CPL.SR_CHQ
        AND PDV_VD_CHQS.CD_BC_CHQ = CHQ_LANC_CPL.CD_BC_CHQ
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          ST_VD = 0
      AND CHQ_LANC_CPL.DT_EMI <> CHQ_LANC_CPL.DT_VENCTO
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , PDV_VD.DT_VD
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT
           , RC_CLI.CD_CLI
UNION ALL
----------------------------------------NCC

SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                  AS CD_CONV
  , ''                 AS DS_CONV
  , 0                  AS VLR_CONV
  , 0                  AS VLR_DINH
  , PDV_VD.VLR_NCC
  , 0                  AS VLR_CHQ_A_VISTA
  , 0                  AS VLR_CHQ_A_PRAZO
  , 0                  AS VLR_CARTAO_APRAZO
  , 0                  AS VLR_CARTAO_DEBITO
  , 0                  AS VLR_CREDIARIO
  , 0                  AS VLR_CONV_PBM
  , ''                 AS NM_USUAL
  , 'A VISTA'          AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                  AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                AS MATRICULA
  , 0                  AS FLAG_REQUER_NOTA_FISCAL
  , 0                  AS FLAG_REQUER_REQUISICAO
  , 0                  AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT AS NM_FILIAL
  , 0                  AS CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_DEV_NCC_PDV_VD ON PDV_VD.CD_FILIAL = PDV_VD_DEV_NCC_PDV_VD.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_DEV_NCC_PDV_VD.CD_VD
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
        ST_VD = 0

        ----------------------------------------PBM
UNION ALL
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , RC_CLI_CONV.CD_CONV
  , RC_CLI_CONV.DS_CONV
  , 0                           AS VLR_CONV
  , 0                           AS VLR_DINH
  , 0                           AS VLR_NCC
  , 0                           AS VLR_CHQ_A_VISTA
  , 0                           AS VLR_CHQ_A_PRAZO
  , 0                           AS VLR_CARTAO_APRAZO
  , 0                           AS VLR_CARTAO_DEBITO
  , 0                           AS VLR_CREDIARIO
  , SUM(PDV_VD.VLR_CONV_PBM)    AS VLR_CONV_PBM
  , ''                          AS NM_USUAL
  , 'A PRAZO'                   AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 1                           AS CONV_PBM
  , PDV_VD_IT_VD_PBM.CD_CLI_PBM AS CD_CLI
  , RC_CLI.NM_FANT
  , '0'                         AS MATRICULA
  , FLAG_REQUER_NOTA_FISCAL
  , FLAG_REQUER_REQUISICAO
  , OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT          AS NM_FILIAL
  , 0                           AS CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN PDV_VD_IT_VD_PBM ON PDV_VD.CD_EMP = PDV_VD_IT_VD_PBM.CD_EMP
        AND PDV_VD.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL
        AND PDV_VD.CD_VD = PDV_VD_IT_VD_PBM.CD_VD
         INNER JOIN RC_CLI_CONV ON PDV_VD_IT_VD_PBM.CD_CLI_PBM = RC_CLI_CONV.CD_CLI
         INNER JOIN RC_CLI ON PDV_VD_IT_VD_PBM.CD_CLI_PBM = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          ST_VD = 0
      AND PDV_VD.VLR_CONV_PBM > 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , RC_CLI_CONV.CD_CONV
           , RC_CLI_CONV.DS_CONV
           , PDV_VD.DT_VD
           , PDV_VD_IT_VD_PBM.CD_CLI_PBM
           , RC_CLI.NM_FANT
           , FLAG_REQUER_NOTA_FISCAL
           , FLAG_REQUER_REQUISICAO
           , OBRIG_RECEIT
           , PRC_FILIAL.NM_FANT
           ------------------------------------------- CONVENIO NORMAL
UNION ALL
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , RC_CLI_CONV.CD_CONV
  , RC_CLI_CONV.DS_CONV
  , SUM(PDV_VD.VLR_CONV) AS VLR_CONV
  , 0                    AS VLR_DINH
  , 0                    AS VLR_NCC
  , 0                    AS VLR_CHQ_A_VISTA
  , 0                    AS VLR_CHQ_A_PRAZO
  , 0                    AS VLR_CARTAO_APRAZO
  , 0                    AS VLR_CARTAO_DEBITO
  , 0                    AS VLR_CREDIARIO
  , 0                    AS VLR_CONV_PBM
  , ''                   AS NN_USUAL
  , 'A PRAZO'            AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                    AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , RC_CLI_CONV_RC_CLI.MATRICULA
  , FLAG_REQUER_NOTA_FISCAL
  , FLAG_REQUER_REQUISICAO
  , OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT   AS NM_FILIAL
  , 0                    AS CD_ADM_CARTAO
    FROM PDV_VD
         LEFT JOIN  RC_CLI_CONV_RC_CLI ON PDV_VD.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
         INNER JOIN RC_CLI_CONV ON PDV_VD.CD_CONV = RC_CLI_CONV.CD_CONV
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          ST_VD = 0
      AND PDV_VD.VLR_CONV > 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , RC_CLI_CONV.CD_CONV
           , RC_CLI_CONV.DS_CONV
           , PDV_VD.DT_VD
           , RC_CLI.CD_CLI
           , RC_CLI.NM_FANT
           , RC_CLI_CONV_RC_CLI.MATRICULA
           , FLAG_REQUER_NOTA_FISCAL
           , FLAG_REQUER_REQUISICAO
           , OBRIG_RECEIT
           , PRC_FILIAL.NM_FANT

           ------------------------------------------- DINHEIRO
UNION ALL
SELECT
    PDV_VD.CD_EMP
  , PDV_VD.CD_FILIAL
  , PDV_VD.CD_VD
  , PDV_VD.CD_CX
  , PDV_VD.NR_ECF
  , 0                    AS CD_CONV
  , ''                   AS DS_CONV
  , 0                    AS VLR_CONV
  , SUM(PDV_VD.VLR_DINH) AS VLR_DINH
  , 0                    AS VLR_NCC
  , 0                    AS VLR_CHQ_A_VISTA
  , 0                    AS VLR_CHQ_A_PRAZO
  , 0                    AS VLR_CARTAO_APRAZO
  , 0                    AS VLR_CARTAO_DEBITO
  , 0                    AS VLR_CREDIARIO
  , 0                    AS VLR_CONV_PBM
  , ''                   AS NM_USUAL
  , 'A VISTA'            AS TIPO_VENDA
  , PDV_VD.DT_VD
  , 0                    AS CONV_PBM
  , RC_CLI.CD_CLI
  , RC_CLI.NM_FANT
  , '0'                  AS MATRICULA
  , 0                    AS FLAG_REQUER_NOTA_FISCAL
  , 0                    AS FLAG_REQUER_REQUISICAO
  , 0                    AS OBRIG_RECEIT
  , PRC_FILIAL.NM_FANT   AS NM_FILIAL
  , 0                    AS CD_ADM_CARTAO
    FROM PDV_VD
         INNER JOIN RC_CLI ON PDV_VD.CD_CLI = RC_CLI.CD_CLI
         INNER JOIN PRC_FILIAL ON PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP
        AND PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
    WHERE
          ST_VD = 0
      AND PDV_VD.VLR_DINH <> 0
    GROUP BY PDV_VD.CD_EMP
           , PDV_VD.CD_FILIAL
           , PDV_VD.CD_VD
           , PDV_VD.CD_CX
           , PDV_VD.NR_ECF
           , PDV_VD.DT_VD
           , RC_CLI.CD_CLI
           , RC_CLI.NM_FANT
           , PRC_FILIAL.NM_FANT;
GO
